import argparse
import os.path

import shortcuts
from shortcuts.utils import download_shortcut, is_shortcut_url
import collections
import copy
import plistlib
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Type, Union
from utils import *
from tqdm import tqdm
import pandas as pd
from Convert_ShortCut_to_Python import convert_shortcut

import os


import collections
from typing import Any, Dict, List, Tuple

def get_dict_structure(d: Dict[str, Any]) -> Tuple:
    """
    Get the structure of a dictionary by recursively examining its keys and nested dictionaries.
    """
    structure = []
    for key, value in sorted(d.items()):
        if isinstance(value, dict):
            structure.append((key, get_dict_structure(value)))
        else:
            structure.append((key, type(value).__name__))
    return tuple(structure)

def count_structures(dicts: List[Dict[str, Any]]) -> Dict[Tuple, int]:
    """
    Count the occurrence of each unique dictionary structure in the list.
    """
    structure_counts = collections.Counter()
    for d in dicts:
        structure = get_dict_structure(d)
        structure_counts[structure] += 1
    return structure_counts


def get_specific_action(action_name=None):
    set_controls = set()

    folder_path = '/Routinehub Source File Dataset'

    _set = set()
    structure_counts = collections.Counter()

    for root, dirs, files in os.walk(folder_path):
        for file_name in files:
            if file_name.endswith('.plist') or file_name.endswith('.shortcut'):
                with open(os.path.join(root, file_name), 'rb') as f:
                    shortcut = f.read()
                try:
                    shortcut = plistlib.loads(shortcut)
                    for action in shortcut['WFWorkflowActions']:
                        if action_name.lower() in action['WFWorkflowActionIdentifier'].lower() and 'Aggrandizements' in str(action):
                            structure = get_dict_structure(action)
                            structure_counts[structure] += 1
                            if structure_counts[structure] == 1:
                                pattern = re.compile(r"'Type':\s*'([^']*Aggrandizement)'")

                                matches = pattern.findall(str(action))

                                for match in matches:
                                    if match not in _set:
                                        print(action)
                                        print()
                                    _set.add(match)
                except:
                    raise Exception

    print(_set)

get_specific_action('is')
